/*____________________________________________________________________________
	Copyright( C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: PGPSpaceEdit.c,v 1.1 2001/03/21 00:12:54 dallen Exp $
____________________________________________________________________________*/

#include <gnome.h>
#include <ctype.h>
#include "pgpPubTypes.h"
#include "pgpMem.h"
#include "pgpContext.h"
#include "pgpPFLPriv.h"
#include "PGPSpaceEdit.h"

#define CKERR			if( IsPGPError( err ) ) { goto done; }
#define CKNULL(p)		if( IsNull(p) ) {					\
							err = kPGPError_OutOfMemory;	\
							goto done; }

#define kMaxPassphraseLen		256
#define kMaxSpacesPerChar		4

typedef struct
{
	gchar			szRealText[kMaxPassphraseLen];
	PGPUInt32		uNumSpaces[kMaxPassphraseLen];
	PGPUInt32		uPosition;
	PGPBoolean		bHideText;
	GtkWidget *		wEditable;
} SEData;


	static PGPError
SEInit(
	SEData *	psed,
	GtkWidget *	wTextBox )
{
	PGPUInt32		i		= 0;

	pgpClearMemory( psed, sizeof( SEData ) );

	srand( time( NULL ) );

	for( i = 0; i < kMaxPassphraseLen; i++ )
		psed->uNumSpaces[i] = rand() % kMaxSpacesPerChar + 1;

	psed->wEditable = GTK_WIDGET( GTK_EDITABLE( wTextBox ) );

	return kPGPError_NoErr;
}

	static void
sUpdateShownSpaces(
	SEData *		psed )
{
	PGPUInt32		i				= 0;
	PGPUInt32		uNumSpaces		= 0;
	gchar			szSpaces[kMaxPassphraseLen * kMaxSpacesPerChar];
	gint			pos				= 0;

	pgpClearMemory( szSpaces, sizeof( szSpaces ) );

	for( i = 0; i < psed->uPosition; i++ )
		uNumSpaces += psed->uNumSpaces[i];

	for( i = 0; i < uNumSpaces; i++ )
		szSpaces[i] = ' ';

	gtk_editable_delete_text( GTK_EDITABLE( psed->wEditable ), 0, -1 );
	gtk_editable_insert_text( GTK_EDITABLE( psed->wEditable ),
		szSpaces,
		strlen( szSpaces ),
		&pos );

	return;
}

	static void
sBackspaceOverChar(
	SEData *		psed )
{
	psed->szRealText[psed->uPosition--] = '\0';
	sUpdateShownSpaces( psed );

	return;
}

	static gint
sEvent(
	GtkWidget *		widget,
	GdkEvent *		event,
	gpointer		data )
{
	GdkEventKey *	pKey			= NULL;
	SEData *		psed			= (SEData *) data;
	gint			position		= 0;

	(void) widget;

	if( event->type == GDK_KEY_PRESS )
	{
		pKey = (GdkEventKey *) event;

		if( pKey->keyval == GDK_BackSpace )
		{
			if( psed->uPosition > 0 )
				sBackspaceOverChar( psed );
			return TRUE;
		}

		if( pKey->keyval > 255 )
			return TRUE;
		if( iscntrl( pKey->keyval ) )
			return TRUE;

		/*
		printf( "%c (%i): %s %s\n",
			pKey->keyval,
			pKey->keyval,
			gdk_keyval_name( pKey->keyval ),
			iscntrl( pKey->keyval ) ? "(CNTRL)" : "" );
			*/

		position = gtk_editable_get_position( GTK_EDITABLE( psed->wEditable ) );
		gtk_editable_insert_text( GTK_EDITABLE( psed->wEditable ),
			"    ",
			psed->uNumSpaces[psed->uPosition],
			&position );

		psed->szRealText[psed->uPosition++] = pKey->keyval;

		/* XXX Recalculate passphrase quality */

		/* Don't give this event to anybody else */
		return TRUE;
	}

	return FALSE;
}

	void
sDestroy(
	GtkObject *		object,
	gpointer		data )
{
	SEData *		psed		= (SEData *) data;

	if( IsntNull( psed ) )
	{
		pgpClearMemory( psed, sizeof( SEData ) );
		(void) PGPFreeData( psed );
	}
	return;
}

	GtkWidget *
SECreate(
	const gchar *	widget_name, 
	const gchar *	string1,
	const gchar *	string2,
	gint			int1,
	gint			int2 )
{
	PGPError		err					= kPGPError_NoErr;
	GtkWidget *		wScrolledWindow		= NULL;
	GtkWidget *		wTextBox			= NULL;
	SEData *		psed				= NULL;

	(void) widget_name;
	(void) string1;
	(void) string2;
	(void) int1;
	(void) int2;

	wScrolledWindow = gtk_scrolled_window_new( NULL, NULL );
	gtk_widget_ref( wScrolledWindow );
	gtk_widget_show( wScrolledWindow );

	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( wScrolledWindow ),
		GTK_POLICY_NEVER, GTK_POLICY_ALWAYS );

	wTextBox = gtk_text_new( NULL, NULL );
	gtk_widget_ref( wTextBox );
	gtk_widget_show( wTextBox );
	gtk_text_set_editable( GTK_TEXT( wTextBox ), TRUE );

	psed = (SEData *) PGPNewSecureData( PGPGetDefaultMemoryMgr(),
		sizeof( SEData ),
		kPGPMemoryMgrFlags_Clear );
	CKNULL( psed );

	SEInit( psed, wTextBox );

	gtk_object_set_data( GTK_OBJECT( wScrolledWindow ), "SEData", psed );
	gtk_container_add( GTK_CONTAINER( wScrolledWindow ), wTextBox );

	gtk_signal_connect( GTK_OBJECT( wTextBox ),
		"event",
		GTK_SIGNAL_FUNC( sEvent ),
		psed );

	gtk_signal_connect( GTK_OBJECT( wTextBox ),
		"destroy",
		GTK_SIGNAL_FUNC( sDestroy ),
		psed );

done:
	if( IsPGPError( err ) )
	{
		if( IsntNull( psed ) )
			(void) PGPFreeData( psed );
		return NULL;
	}
	else
		return wScrolledWindow;
}

	PGPError
SEShowText(
	GtkWidget *		wSpaceEdit,
	PGPBoolean		bShowText )
{
	PGPError		err			= kPGPError_NoErr;
	SEData *		psed		= NULL;

	psed = (SEData *) gtk_object_get_data( GTK_OBJECT( wSpaceEdit ), "SEData" );
	if( IsNull( psed ) )
		return kPGPError_BadParams;

	/* XXX */

/* done: */
	return err;
}

	PGPError
SEReset(
	GtkWidget *		wSpaceEdit )
{
	PGPError		err			= kPGPError_NoErr;
	SEData *		psed		= NULL;

	psed = (SEData *) gtk_object_get_data( GTK_OBJECT( wSpaceEdit ), "SEData" );
	if( IsNull( psed ) )
		return kPGPError_BadParams;

	pgpClearMemory( psed->szRealText, sizeof( psed->szRealText ) );
	psed->uPosition = 0;

	sUpdateShownSpaces( psed );

/* done: */
	return err;
}

	PGPUInt32
SEGetTextLength(
	GtkWidget *		wSpaceEdit )
{
	SEData *		psed		= NULL;

	psed = (SEData *) gtk_object_get_data( GTK_OBJECT( wSpaceEdit ), "SEData" );
	if( IsNull( psed ) )
		return 0;

	return strlen( psed->szRealText );
}

	PGPError
SEGetText(
	GtkWidget *		wSpaceEdit,
	gchar *			pszText )
{
	PGPError		err			= kPGPError_NoErr;
	SEData *		psed		= NULL;

	PGPValidatePtr( pszText );

	psed = (SEData *) gtk_object_get_data( GTK_OBJECT( wSpaceEdit ), "SEData" );
	if( IsNull( psed ) )
		return kPGPError_BadParams;

	strcpy( pszText, psed->szRealText );

/* done: */
	return err;
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
